# This code is a sample Monte Carlo simulation
# 2025 Bruin Actuarial Society Case Competition

# load libraries
library(tidyverse)
library(actuar) # load this package for rpareto()

# simulation set up
trials <- 100000

# Frequency is Poisson with lambda = 5
set.seed(111)
count <- rpois(trials, lambda = 5)

# using for loop ----------------------------------------------------------

# severity is pareto with shape = 1.5 and scale = 100000
sim_claims <- list()
set.seed(222)
for (i in 1:trials) {
  sim_claims[[i]] <- rpareto(count[i], shape = 1.5, scale = 100000)
}

# projected annual aggregate loss by trial
sim_claims_total <- c()
for (i in 1:trials) {
  sim_claims_total[i] <- sum(sim_claims[[i]])
}

# projected annual aggregate loss with each claim capped by 200K
sim_claims_200 <- list()
sim_claims_total_200 <- c()
for (i in 1:trials) {
  sim_claims_200[[i]] <- pmin(sim_claims[[i]], 200000)
  sim_claims_total_200[i] <- sum(sim_claims_200[[i]])
}

# using sapply functions --------------------------------------------------

# severity is pareto with shape = 1.5 and scale = 100000
set.seed(333)
sim_claims <- sapply(count, rpareto, shape = 1.5, scale = 100000)

# projected annual aggregate loss by trial
sim_claims_total <- sapply(sim_claims, sum)

# projected annual aggregate loss with each claim capped by 200K
sim_claims_200 <- sapply(sim_claims, function(x) pmin(x, 200000))
sim_claims_total_200 <- sapply(sim_claims_200, sum)

# diagnostics -------------------------------------------------------------

# this is average annual aggregate loss
mean(sim_claims_total) # with no insurance
mean(sim_claims_total_200) # for only the 200K retention 

# this is to calculate percentiles
quantile(sim_claims_total, c(0.25, 0.5, 0.75, 0.9, 0.95, 0.99))
